#  This software and supporting documentation are distributed by
#      Institut Federatif de Recherche 49
#      CEA/NeuroSpin, Batiment 145,
#      91191 Gif-sur-Yvette cedex
#      France
#
# This software is governed by the CeCILL license version 2 under
# French law and abiding by the rules of distribution of free software.
# You can  use, modify and/or redistribute the software under the
# terms of the CeCILL license version 2 as circulated by CEA, CNRS
# and INRIA at the following URL "http://www.cecill.info".
#
# As a counterpart to the access to the source code and  rights to copy,
# modify and redistribute granted by the license, users are provided only
# with a limited warranty  and the software's author,  the holder of the
# economic rights,  and the successive licensors  have only  limited
# liability.
#
# In this respect, the user's attention is drawn to the risks associated
# with loading,  using,  modifying and/or developing or reproducing the
# software by the user in light of its specific status of free software,
# that may mean  that it is complicated to manipulate,  and  that  also
# therefore means  that it is reserved for developers  and  experienced
# professionals having in-depth computer knowledge. Users are therefore
# encouraged to load and test the software's suitability as regards their
# requirements in conditions enabling the security of their systems and/or
# data to be ensured and,  more generally, to use and operate it in the
# same conditions as regards security.
#
# The fact that you are presently reading this means that you have had
# knowledge of the CeCILL license version 2 and that you accept its terms.

'''
AIMS / Anatomist volume manipulation
====================================

Loading, handling and viewing a Volume with aims and anatomist
'''

import anatomist.direct.api as anatomist
from soma import aims
from soma.qt_gui.qt_backend import Qt
import sys


# load any volume as a aims.Volume_* object
vol = aims.read('irm.ima')

runloop = False
if Qt.QApplication.instance() is None:
    runloop = True

# initialize Anatomist
a = anatomist.Anatomist()

# convert the carto volume to Anatomist API
avol = a.toAObject(vol)
avol.releaseAppRef()

win = a.createWindow('Axial')

# put volume in window
win.addObjects(avol)

# volume change and update test

# we're just printing a white square in the middle of the volume
vol[100:130, 100:130, 50:70, 0] = 255

# update Anatomist object and its views
avol.setChanged()
avol.notifyObservers()


# fusion test

# have a second volume. We could have loaded another one
# (and it would have been nicer on screen). This example also
# shows the ability to share the volume data with multiple anatomist/aims
# objects
avol2 = a.toAObject(vol)
avol2.releaseAppRef()

# set a different palette on the second object so we can see something
a.setObjectPalette(avol2, 'Blue-Red-fusion')

# another view
win2 = a.createWindow('Axial')

a.addObjects(avol2, win2)

# create the fusion object
fus = a.fusionObjects([avol, avol2], 'Fusion2DMethod')

# show it
win3 = a.createWindow('Sagittal')

a.addObjects(fus, win3)


# display in matplotlib for sphinx_gallery
win3.sphinx_gallery_snapshot()
if runloop and 'sphinx_gallery' not in sys.modules:
    Qt.QApplication.instance().exec_()
if runloop or 'sphinx_gallery' in sys.modules:
    del win, win2, win3, fus, avol, avol2
